/**
* \file: AilAudioSource.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Audio source endpoint implementation using AIL
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*          P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_AILAUDIOSOURCE_H
#define BDCL_AILAUDIOSOURCE_H

#include <string>
#include <memory>
#include <bdcl/BaiduCoreCallbackDealer.h>
#include <bdcl/AditAudioSource.h>

namespace adit { namespace bdcl {

class AilAudioSourceImpl;

/** @class  AilAudioSource
 *  @brief  AIL specific audio source implementation.
 */
class AilAudioSource : public AditAudioSource
{
public:

    AilAudioSource(IAditAudioSourceCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer);
    virtual ~AilAudioSource();

    void setConfigItem(std::string inKey, std::string inValue);

    bool initialize();
    void teardown();

    bool captureStart();
    bool captureStop();

private:
    std::unique_ptr<AilAudioSourceImpl> impl;
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_AILAUDIOSOURCE_H */
